<?php
/**
 * Elementor views manager
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! class_exists( 'Jet_Engine_Render_Dynamic_Image' ) ) {

	class Jet_Engine_Render_Dynamic_Image extends Jet_Engine_Render_Base {

		private $source     = false;
		private $show_field = true;

		public function get_name() {
			return 'jet-listing-dynamic-image';
		}

		public function default_settings() {
			return array(
				'dynamic_image_source'        => 'post_thumbnail',
				'dynamic_image_size'          => 'full',
				'dynamic_avatar_size'         => 50,
				'dynamic_image_source_custom' => '',
				'linked_image'                => true,
				'image_link_source'           => '_permalink',
				'open_in_new'                 => false,
				'hide_if_empty'               => false,
			);
		}

		/**
		 * Render image
		 *
		 * @return [type] [description]
		 */
		public function render_image( $settings ) {

			$listing_source = jet_engine()->listings->data->get_listing_source();
			$source         = isset( $settings['dynamic_image_source'] ) ? $settings['dynamic_image_source'] : 'post_thumbnail';
			$size           = isset( $settings['dynamic_image_size'] ) ? $settings['dynamic_image_size'] : 'full';
			$custom         = isset( $settings['dynamic_image_source_custom'] ) ? $settings['dynamic_image_source_custom'] : false;

			if ( ! $source && ! $custom ) {
				return;
			}

			if ( $custom ) {
				$this->render_image_by_meta_field( $custom, $size, $settings );
				return;
			}

			if ( 'post_thumbnail' === $source ) {

				if ( 'posts' === $listing_source ) {

					$post = jet_engine()->listings->data->get_current_object();

					if ( ! $post ) {
						return;
					}

					if ( ! has_post_thumbnail( $post->ID ) ) {

						if ( ! empty( $settings['hide_if_empty'] ) ) {
							$this->show_field = false;
							return;
						} elseif ( ! empty( $settings['fallback_image'] ) ) {
							if ( is_array( $settings['fallback_image'] ) ) {
								echo wp_get_attachment_image( $settings['fallback_image']['id'], $size );
							} else {
								echo wp_get_attachment_image( $settings['fallback_image'], $size );
							}
						}

						return;

					}

					echo get_the_post_thumbnail( $post->ID, $size, array( 'alt' => get_the_title() ) );

					return;

				}

			} elseif ( 'user_avatar' === $source && 'users' === $listing_source ) {

				$user = jet_engine()->listings->data->get_current_object();

				if ( $user ) {
					$size = ! empty( $settings['dynamic_avatar_size'] ) ? $settings['dynamic_avatar_size'] : array( 'size' => 50 );
					$size = ! empty( $size['size'] ) ? $size['size'] : 50;

					echo str_replace( 'avatar ', 'jet-avatar ', get_avatar( $user->ID, $size ) );
				} elseif ( ! empty( $settings['hide_if_empty'] ) ) {
					$this->show_field = false;
					return;
				} elseif ( ! empty( $settings['fallback_image'] ) ) {
					if ( is_array( $settings['fallback_image'] ) ) {
						echo wp_get_attachment_image( $settings['fallback_image']['id'], $size );
					} else {
						echo wp_get_attachment_image( $settings['fallback_image'], $size );
					}
				}

			} elseif ( 'options_page' === $source ) {

				$option = ! empty( $settings['dynamic_field_option'] ) ? $settings['dynamic_field_option'] : false;
				$image  = jet_engine()->listings->data->get_option( $option );

				if ( ! $image ) {

					if ( ! empty( $settings['hide_if_empty'] ) ) {
						$this->show_field = false;
						return;
					} elseif ( ! empty( $settings['fallback_image'] ) ) {
						if ( is_array( $settings['fallback_image'] ) ) {
							echo wp_get_attachment_image( $settings['fallback_image']['id'], $size );
						} else {
							echo wp_get_attachment_image( $settings['fallback_image'], $size );
						}
					} else {
						return;
					}

				} else {
					$alt = get_post_meta( $image, '_wp_attachment_image_alt', true );
					echo wp_get_attachment_image( $image, $size, false, array( 'alt' => $alt ) );
				}

			} else {
				$this->render_image_by_meta_field( $source, $size, $settings );
			}

		}

		public function render_image_by_meta_field( $field, $size = 'full', $settings = array() ) {

			$custom_output = apply_filters(
				'jet-engine/listings/dynamic-image/custom-image',
				false,
				$this->get_settings()
			);

			if ( $custom_output ) {
				echo $custom_output;
			}

			$image = false;

			if ( jet_engine()->relations->is_relation_key( $field ) ) {
				$related_post = get_post_meta( get_the_ID(), $field, false );
				if ( ! empty( $related_post ) ) {
					$related_post = $related_post[0];
					if ( has_post_thumbnail( $related_post ) ) {
						$image = get_post_thumbnail_id( $related_post );
					}
				}
			} else {
				$image = jet_engine()->listings->data->get_meta( $field );
			}

			if ( is_array( $image ) ) {
				$image = $image[0];
			}

			if ( ! $image ) {

				if ( ! empty( $settings['hide_if_empty'] ) ) {
					$this->show_field = false;
					return;
				} elseif ( ! empty( $settings['fallback_image'] ) ) {
					if ( is_array( $settings['fallback_image'] ) ) {
						$image = wp_get_attachment_image_url( $settings['fallback_image']['id'], $size );
					} else {
						$image = wp_get_attachment_image_url( $settings['fallback_image'], $size );
					}
				} else {
					return;
				}

			}

			if ( filter_var( $image, FILTER_VALIDATE_URL ) ) {
				printf( '<img src="%1$s" alt="%2$s">', $image, get_the_title() );
			} else {
				echo wp_get_attachment_image( $image, $size, false, array( 'alt' => get_the_title() ) );
			}

		}

		public function get_image_url( $settings ) {

			$is_linked = $this->get( 'linked_image' );

			if ( ! $is_linked ) {
				return false;
			}

			$source = ! empty( $settings['image_link_source'] ) ? $settings['image_link_source'] : '_permalink';
			$custom = ! empty( $settings['image_link_source_custom'] ) ? $settings['image_link_source_custom'] : false;

			$url = apply_filters(
				'jet-engine/listings/dynamic-image/custom-url',
				false,
				$settings
			);

			if ( false !== $url ) {
				return $url;
			}

			if ( $custom ) {
				$url = jet_engine()->listings->data->get_meta( $custom );
			} elseif ( '_permalink' === $source ) {
				$url = jet_engine()->listings->data->get_current_object_permalink();
			} elseif ( 'options_page' === $source ) {
				$option = ! empty( $settings['image_link_option'] ) ? $settings['image_link_option'] : false;
				$url    = jet_engine()->listings->data->get_option( $option );
			} elseif ( $source ) {
				$url = jet_engine()->listings->data->get_meta( $source );
			}

			if ( is_array( $url ) ) {
				return $url[0];
			} else {
				return $url;
			}

		}

		public function render() {

			$base_class = $this->get_name();
			$settings   = $this->get_settings();

			$classes = array(
				'jet-listing',
				$base_class,
			);

			if ( ! empty( $settings['className'] ) ) {
				$classes[] = esc_attr( $settings['className'] );
			}

			printf( '<div class="%1$s">', implode( ' ', $classes ) );

				do_action( 'jet-engine/listing/dynamic-image/before-image', $this );

				$image_url = $this->get_image_url( $settings );

				if ( $image_url ) {

					$open_in_new = isset( $settings['open_in_new'] ) ? $settings['open_in_new'] : '';
					$rel_attr    = isset( $settings['rel_attr'] ) ? esc_attr( $settings['rel_attr'] ) : '';
					$rel         = '';
					$target      = '';

					if ( $rel_attr ) {
						$rel = sprintf( ' rel="%s"', $rel_attr );
					}

					if ( $open_in_new ) {
						$target = ' target="_blank"';
					}

					printf( '<a href="%1$s" class="%2$s__link"%3$s%4$s>', $image_url, $base_class, $rel, $target );
				}

				$this->render_image( $settings );

				if ( $image_url ) {
					echo '</a>';
				}

				do_action( 'jet-engine/listing/dynamic-image/after-image', $this );

			echo '</div>';

		}

	}

}
