<?php
/**
 * Main dashboard template
 */
?>
<div class="wrap">
	<h1 class="cs-vui-title"><?php _e( 'JetEngine dashboard', 'jet-engine' ); ?></h1>
	<div id="jet_engine_dashboard">
		<div class="cx-vui-panel">
			<cx-vui-tabs
				:in-panel="false"
				value="modules"
				layout="vertical"
			>
				<cx-vui-tabs-panel
					name="modules"
					label="<?php _e( 'Modules', 'jet-engine' ); ?>"
					key="modules"
				>
					<cx-vui-component-wrapper
						label="<?php _e( 'Available Modules', 'jet-engine' ); ?>"
						description="<?php _e( 'Enable/disable additional JetEngine features', 'jet-engine' ); ?>"
						:wrapper-css="[ 'vertical-fullwidth' ]"
					>
						<div class="cx-vui-inner-panel">
							<div tabindex="0" class="cx-vui-repeater">
								<div class="cx-vui-repeater__items">
									<div :class="{ 'cx-vui-repeater-item': true, 'cx-vui-panel': true, 'cx-vui-repeater-item--is-collpased': false }" v-for="module in availableModules">
										<div :class="{ 'cx-vui-repeater-item__heading': true, 'cx-vui-repeater-item__heading--is-collpased': moduleDetails !== module.value }">
											<div class="cx-vui-repeater-item__heading-start">
												<cx-vui-switcher
													:prevent-wrap="true"
													:value="isActive( module.value )"
													@input="switchActive( $event, module )"
												></cx-vui-switcher>
												&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
												<div class="cx-vui-repeater-item__title je-module-heading" @click="switchActive( $event, module )">
													{{ module.label }}
													<div :class="{ 'je-module-icon': true, 'je-module-icon--elementor': true, 'je-module-icon--inactive': ! module.isElementor }">
														<svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 100 100" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 11.1111C0 4.97462 4.97504 0 11.1111 0H88.8889C95.025 0 100 4.97462 100 11.1111V88.8889C100 95.0254 95.025 100 88.8889 100H11.1111C4.97504 100 0 95.0254 0 88.8889V11.1111Z" fill="url(#paint0_linear)"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M38.6677 27.8688H30.0005V72.1311H38.6677V27.8688ZM73.3338 54.4174V45.5649H47.3349V54.4174H73.3338ZM73.3338 27.8688V36.7213H47.3349V27.8688H73.3338ZM73.3338 72.1117V63.2592H47.3349V72.1117H73.3338Z" fill="white"></path><defs><linearGradient id="paint0_linear" x1="100" y1="0" x2="1.68772" y2="102.124" gradientUnits="userSpaceOnUse"><stop stop-color="#E9325D"></stop><stop offset="0.484375" stop-color="#982F67"></stop><stop offset="1" stop-color="#392B73"></stop></linearGradient></defs></svg>
														<div class="cx-vui-tooltip" v-if="module.isElementor">
															<?php _e( 'Supports Elementor views', 'jet-engine' ); ?>
														</div>
														<div class="cx-vui-tooltip" v-else>
															<?php _e( 'Don`t supports Elementor views', 'jet-engine' ); ?>
														</div>
													</div>
													<div :class="{ 'je-module-icon': true, 'je-module-icon--blocks': true, 'je-module-icon--inactive': ! module.isBlocks }">
														<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 16 18" fill="none"><path d="M9.72866 8.05778C9.66881 8.01709 9.58743 8.03384 9.54673 8.09369C9.30976 8.45035 8.80708 8.4695 8.78075 8.4695C8.77596 8.4695 8.77357 8.4695 8.76878 8.4695C8.14881 8.4695 7.91183 8.99851 7.90226 9.02005C7.87353 9.08707 7.90465 9.16367 7.96928 9.1924C7.98604 9.19958 8.00519 9.20437 8.02194 9.20437C8.07221 9.20437 8.12008 9.17564 8.14163 9.12537C8.14402 9.12059 8.30679 8.75674 8.72569 8.73281V9.41022C8.70894 9.55624 8.63952 9.67114 8.51744 9.75731C8.39057 9.84588 8.22062 9.89136 8.01237 9.89136C7.76342 9.89136 7.55996 9.80519 7.40915 9.63523C7.25596 9.46528 7.17936 9.22352 7.17936 8.91233L7.18175 8.1655C7.19372 7.89022 7.26792 7.67239 7.40915 7.5168C7.56235 7.34685 7.76342 7.26068 8.01237 7.26068C8.22062 7.26068 8.39057 7.30616 8.51744 7.39472C8.64431 7.48329 8.71612 7.60537 8.72809 7.76335C8.72809 7.76814 8.72809 7.77532 8.72809 7.78011C8.72809 7.87107 8.80229 7.94528 8.89325 7.94528C8.98421 7.94528 9.05842 7.87107 9.05842 7.78011C9.05842 7.77532 9.05842 7.76814 9.05842 7.76335C9.03448 7.52638 8.92676 7.33967 8.73287 7.19844C8.53898 7.05721 8.29722 6.98779 8.00519 6.98779C7.6581 6.98779 7.37803 7.10269 7.16499 7.33009C6.96392 7.54313 6.8586 7.8232 6.84663 8.16789C6.84663 8.19183 6.84424 8.21577 6.84424 8.2397L6.84663 8.91233H6.84424C6.84424 9.29293 6.95195 9.59693 7.16499 9.82434C7.37803 10.0517 7.6581 10.1666 8.00519 10.1666C8.29722 10.1666 8.53898 10.0972 8.73287 9.95599C8.91001 9.82673 9.01533 9.65678 9.05124 9.44613L9.05842 8.69451C9.27625 8.64184 9.57307 8.52216 9.75977 8.2397C9.80765 8.17986 9.79089 8.09847 9.72866 8.05778Z" fill="#0F172A"/><path d="M12.0351 0.355413H13.8711C13.9525 0.355413 14.0195 0.288389 14.0195 0.207004C14.0195 0.125618 13.9525 0.0585938 13.8711 0.0585938H12.0351C11.9537 0.0585938 11.8867 0.125618 11.8867 0.207004C11.8867 0.288389 11.9537 0.355413 12.0351 0.355413Z" fill="#0F172A"/><path d="M2.19187 0.355413H4.02784C4.10923 0.355413 4.17625 0.288389 4.17625 0.207004C4.17625 0.125618 4.10923 0.0585938 4.02784 0.0585938H2.19187C2.11048 0.0585938 2.04346 0.125618 2.04346 0.207004C2.04346 0.288389 2.10809 0.355413 2.19187 0.355413Z" fill="#0F172A"/><path d="M13.9677 1.84656C14.0491 1.84656 14.1151 1.78056 14.1151 1.69916C14.1151 1.61775 14.0491 1.55176 13.9677 1.55176C13.8863 1.55176 13.8203 1.61775 13.8203 1.69916C13.8203 1.78056 13.8863 1.84656 13.9677 1.84656Z" fill="#0F172A"/><path d="M7.99506 1.38416C8.07646 1.38416 8.14246 1.31816 8.14246 1.23676C8.14246 1.15535 8.07646 1.08936 7.99506 1.08936C7.91365 1.08936 7.84766 1.15535 7.84766 1.23676C7.84766 1.31816 7.91365 1.38416 7.99506 1.38416Z" fill="#0F172A"/><path d="M5.23808 1.70536C5.24047 1.70536 5.24286 1.70536 5.24526 1.70536C5.80299 1.70536 6.05194 1.35587 6.24104 1.03033C6.30328 0.922614 6.53307 0.563558 6.85862 0.470203C7.26076 0.352911 7.68923 0.539621 7.85679 0.905858C7.88073 0.958519 7.93339 0.989638 7.98605 0.992031C7.98845 0.992031 7.99084 0.992031 7.99323 0.992031C7.99563 0.992031 7.99802 0.992031 8.00281 0.992031C8.05547 0.989638 8.10813 0.958519 8.13207 0.905858C8.29963 0.539621 8.7281 0.352911 9.13024 0.470203C9.45579 0.565951 9.68558 0.922614 9.74782 1.03033C9.93692 1.35827 10.1859 1.70536 10.7508 1.70536C11.0907 1.70536 11.4928 1.45162 11.6053 0.965701C11.6987 0.563558 11.5263 0.199714 11.1505 0.0153987C11.0763 -0.0205069 10.9878 0.0082177 10.9519 0.0824226C10.9159 0.156628 10.9447 0.245195 11.0189 0.2811C11.3755 0.458235 11.3444 0.77181 11.3157 0.898677C11.2582 1.14762 11.038 1.41093 10.7484 1.41093C10.3774 1.41093 10.2002 1.22422 10.0016 0.881921C9.90341 0.714361 9.63053 0.307431 9.21163 0.185352C8.75443 0.0513043 8.2709 0.211683 7.99323 0.563558C7.71556 0.211683 7.23203 0.0513043 6.77484 0.185352C6.35594 0.307431 6.08306 0.714361 5.98491 0.881921C5.78624 1.22422 5.6091 1.41093 5.24526 1.41093C5.24286 1.41093 5.24047 1.41093 5.24047 1.41093C4.9245 1.40854 4.72343 1.18832 4.66598 0.970488C4.63726 0.867559 4.57741 0.515684 4.97956 0.276313C5.04897 0.23562 5.07291 0.144659 5.02982 0.0728477C4.98674 0.00343024 4.89817 -0.0205068 4.82636 0.0225799C4.36437 0.297856 4.29256 0.733511 4.37874 1.04948C4.48406 1.43965 4.83115 1.70296 5.23808 1.70536Z" fill="#0F172A"/><path d="M1.97162 1.84656C2.05303 1.84656 2.11902 1.78056 2.11902 1.69916C2.11902 1.61775 2.05303 1.55176 1.97162 1.55176C1.89021 1.55176 1.82422 1.61775 1.82422 1.69916C1.82422 1.78056 1.89021 1.84656 1.97162 1.84656Z" fill="#0F172A"/><path d="M1.55756 0.37146C1.63896 0.37146 1.70496 0.305467 1.70496 0.22406C1.70496 0.142653 1.63896 0.0766602 1.55756 0.0766602C1.47615 0.0766602 1.41016 0.142653 1.41016 0.22406C1.41016 0.305467 1.47615 0.37146 1.55756 0.37146Z" fill="#0F172A"/><path d="M14.4902 0.37146C14.5716 0.37146 14.6376 0.305467 14.6376 0.22406C14.6376 0.142653 14.5716 0.0766602 14.4902 0.0766602C14.4088 0.0766602 14.3428 0.142653 14.3428 0.22406C14.3428 0.305467 14.4088 0.37146 14.4902 0.37146Z" fill="#0F172A"/><path d="M15.2763 9.87586C15.3577 9.87586 15.4237 9.80986 15.4237 9.72846C15.4237 9.64705 15.3577 9.58105 15.2763 9.58105C15.1949 9.58105 15.1289 9.64705 15.1289 9.72846C15.1289 9.80986 15.1949 9.87586 15.2763 9.87586Z" fill="#0F172A"/><path d="M14.6826 13.2679C14.764 13.2679 14.83 13.2019 14.83 13.1205C14.83 13.0391 14.764 12.9731 14.6826 12.9731C14.6011 12.9731 14.5352 13.0391 14.5352 13.1205C14.5352 13.2019 14.6011 13.2679 14.6826 13.2679Z" fill="#0F172A"/><path d="M13.7289 13.683C13.8103 13.683 13.8763 13.617 13.8763 13.5356C13.8763 13.4542 13.8103 13.3882 13.7289 13.3882C13.6475 13.3882 13.5815 13.4542 13.5815 13.5356C13.5815 13.617 13.6475 13.683 13.7289 13.683Z" fill="#0F172A"/><path d="M4.93457 0.765495C4.93457 0.985716 5.1141 1.16524 5.33432 1.16524C5.55454 1.16524 5.73407 0.985716 5.73407 0.765495C5.73407 0.545274 5.55454 0.365746 5.33432 0.365746C5.1141 0.363353 4.93457 0.542881 4.93457 0.765495ZM5.33432 0.660172C5.39177 0.660172 5.43964 0.708046 5.43964 0.765495C5.43964 0.822944 5.39177 0.870818 5.33432 0.870818C5.27687 0.870818 5.229 0.822944 5.229 0.765495C5.229 0.708046 5.27687 0.660172 5.33432 0.660172Z" fill="#0F172A"/><path d="M10.7162 1.16522C10.9364 1.16522 11.1159 0.985692 11.1159 0.765471C11.1159 0.545251 10.9364 0.365723 10.7162 0.365723C10.4959 0.365723 10.3164 0.545251 10.3164 0.765471C10.3164 0.985692 10.4959 1.16522 10.7162 1.16522ZM10.7162 0.660149C10.7736 0.660149 10.8215 0.708023 10.8215 0.765471C10.8215 0.82292 10.7736 0.870795 10.7162 0.870795C10.6587 0.870795 10.6108 0.82292 10.6108 0.765471C10.6108 0.708023 10.6587 0.660149 10.7162 0.660149Z" fill="#0F172A"/><path d="M8.39552 1.01366C8.31892 1.04238 8.28062 1.12616 8.30934 1.20276C8.33807 1.27936 8.42185 1.31766 8.49844 1.29133C8.52238 1.28175 9.09687 1.09026 9.53731 1.77486C9.56604 1.81794 9.61391 1.84188 9.66179 1.84188C9.68812 1.84188 9.71684 1.8347 9.74078 1.81794C9.81019 1.77486 9.82934 1.6815 9.78626 1.61448C9.32667 0.903548 8.67558 0.910729 8.39552 1.01366Z" fill="#0F172A"/><path d="M7.59435 1.01199C7.57281 1.00481 7.37652 0.935394 7.10843 0.976087C6.85948 1.01199 6.50282 1.15322 6.206 1.61521C6.16291 1.68462 6.18206 1.77559 6.25148 1.81867C6.27542 1.83543 6.30414 1.84261 6.33047 1.84261C6.37835 1.84261 6.42622 1.81867 6.45495 1.77559C6.89299 1.09099 7.46748 1.28248 7.49381 1.29206C7.57041 1.32078 7.65419 1.28009 7.68292 1.20349C7.71164 1.12689 7.67095 1.04072 7.59435 1.01199Z" fill="#0F172A"/><path d="M14.4068 1.43363L15.1273 0.614983V1.79508C15.1273 1.87647 15.1943 1.94349 15.2757 1.94349C15.3571 1.94349 15.4241 1.87647 15.4241 1.79508V0.224809C15.4241 0.162573 15.3858 0.107517 15.3284 0.0859739C15.2709 0.0644305 15.2063 0.0811865 15.1656 0.126667L14.1866 1.23974C14.1315 1.30198 14.1387 1.39533 14.201 1.44799C14.2584 1.50305 14.3518 1.49587 14.4068 1.43363Z" fill="#0F172A"/><path d="M0.74709 1.94588C0.828476 1.94588 0.8955 1.87886 0.8955 1.79747V0.617377L1.61601 1.43603C1.67106 1.49826 1.76442 1.50305 1.82426 1.45039C1.88649 1.39533 1.89128 1.30198 1.83862 1.24213L0.859594 0.126667C0.818901 0.0811865 0.754271 0.0644305 0.696822 0.0859738C0.639374 0.107517 0.601074 0.162573 0.601074 0.224809V1.79747C0.601074 1.87886 0.665704 1.94588 0.74709 1.94588Z" fill="#0F172A"/><path d="M11.1942 2.08178C11.1247 2.07699 11.0601 2.12486 11.0434 2.19189C11.0266 2.2613 11.0601 2.33312 11.1223 2.36184C11.3569 2.47195 11.57 2.51504 11.7615 2.51504C12.1277 2.51504 12.4197 2.35466 12.6232 2.1871C12.9487 1.919 13.1163 1.58149 13.1235 1.56713C13.157 1.49771 13.1331 1.41393 13.066 1.37563C12.9152 1.28707 12.6543 1.23201 12.257 1.47377C12.0583 1.59585 11.9051 1.74187 11.8788 1.7682C11.5149 2.08896 11.2109 2.08178 11.1942 2.08178ZM12.0774 1.98842C12.0798 1.98603 12.0822 1.98363 12.0846 1.98124C12.1971 1.86874 12.5155 1.60782 12.7644 1.59585C12.6926 1.69878 12.5849 1.83762 12.4389 1.9597C12.2235 2.13683 11.9937 2.223 11.7495 2.21822C11.85 2.16556 11.9625 2.08896 12.0774 1.98842Z" fill="#0F172A"/><path d="M2.99827 1.37385C2.93125 1.41214 2.90731 1.49592 2.94082 1.56534C2.948 1.5797 3.11556 1.91722 3.4411 2.18531C3.64457 2.35287 3.93421 2.51325 4.30284 2.51325C4.49673 2.51325 4.70977 2.47016 4.94196 2.36005C5.00659 2.32893 5.03771 2.25952 5.02095 2.1901C5.0042 2.12068 4.94196 2.0752 4.87015 2.0776C4.85818 2.0776 4.55179 2.08717 4.18794 1.76641C4.16161 1.74008 4.00841 1.59407 3.80974 1.47199C3.41238 1.23262 3.14907 1.28767 2.99827 1.37385ZM3.98926 1.98663C4.10177 2.08717 4.21427 2.16138 4.3172 2.21643C3.80016 2.22122 3.45786 1.82626 3.30227 1.59407C3.55122 1.60604 3.86958 1.86695 3.98208 1.97945C3.98448 1.98185 3.98687 1.98424 3.98926 1.98663Z" fill="#0F172A"/><path d="M15.459 14.023C15.3106 13.8985 15.1478 13.8267 14.997 13.786C15.0545 13.7429 15.1095 13.6927 15.1574 13.6376C15.5237 13.2067 15.526 12.5724 15.1622 12.1607C15.1071 12.0985 15.0138 12.0937 14.9539 12.1487C14.8917 12.2038 14.8869 12.2971 14.942 12.357C15.2077 12.6586 15.2029 13.1254 14.9324 13.4461C14.7122 13.7046 14.2933 13.7669 14.1688 13.7812C13.793 13.8219 13.3717 13.9081 13.1443 14.4227C13.1084 14.5017 13.0869 14.5903 13.0821 14.6861C13.0294 14.6693 12.972 14.6597 12.9145 14.6597C12.6153 14.6597 12.3711 14.9039 12.3711 15.2031C12.3711 15.409 12.486 15.5885 12.656 15.6794C12.6057 15.7249 12.5578 15.7752 12.5148 15.8326C12.0121 15.1552 11.2078 14.7291 10.3221 14.7291C10.1953 14.7291 10.0684 14.7387 9.94631 14.7555C10.674 14.5329 11.3514 14.1858 11.969 13.7262C12.7661 13.1301 13.4292 12.3522 13.884 11.4785C14.3627 10.5593 14.6045 9.56591 14.6045 8.53183C14.6045 8.52465 14.6045 8.51986 14.6045 8.51268C14.6045 8.51029 14.6045 8.51029 14.6045 8.50789C14.6045 8.5055 14.6045 8.50311 14.6045 8.50071C14.5997 7.66052 14.413 6.90411 14.1473 6.25302C14.2454 6.27217 14.3388 6.27935 14.4225 6.27935C15.0425 6.27935 15.3154 5.85327 15.3441 5.80301C15.4782 5.578 15.4997 5.30511 15.4231 5.05856C15.4255 5.05138 15.4255 5.04181 15.4255 5.03223V2.33452C15.4255 2.25314 15.3585 2.18611 15.2771 2.18611C15.1957 2.18611 15.1287 2.25314 15.1287 2.33452V4.60136C14.8774 4.38354 14.5135 4.3596 14.3627 4.3596C14.0707 4.36199 13.8887 4.31651 13.7547 4.08672C13.6422 3.89283 13.7068 3.69175 13.8193 3.57686C13.9606 3.43323 14.1616 3.41408 14.3579 3.5218C14.4297 3.5601 14.5207 3.53616 14.559 3.46435C14.5973 3.39254 14.5733 3.30158 14.5015 3.26328C14.1904 3.09093 13.8409 3.13402 13.6087 3.3686C13.3789 3.60319 13.3358 3.95028 13.4986 4.23273C13.7116 4.59897 14.0348 4.65163 14.3531 4.65163C14.3579 4.65163 14.3603 4.65163 14.3651 4.65163C14.4608 4.65163 14.7696 4.66599 14.9468 4.83355C15.1766 5.05138 15.2364 5.39368 15.0856 5.64741C15.0856 5.64741 15.0832 5.64981 15.0832 5.6522C15.0712 5.67374 14.7864 6.15727 13.9917 5.90354C13.7523 5.39607 13.4746 4.96521 13.2161 4.62051L13.0988 4.70908L13.2161 4.61812L13.1682 4.55588C12.6584 3.70133 13.2472 2.79172 13.5536 2.40633L13.726 2.21005C13.7786 2.14781 13.7739 2.05446 13.7116 2.0018C13.6518 1.95153 13.5656 1.95392 13.5105 2.00898C13.5058 2.01377 13.4794 2.0401 13.4387 2.08558C13.173 2.35607 12.1342 3.31355 11.1264 2.81326L11.0977 2.79411L11.0833 2.78454C10.1809 2.29862 9.29044 2.01855 8.44067 1.94674C8.33056 1.6954 8.18454 1.50391 8.00023 1.50391C7.81352 1.50391 7.6675 1.6978 7.555 1.95392C6.36533 2.00658 4.88602 2.77496 4.82378 2.80608C3.81124 3.31594 2.76758 2.35367 2.50188 2.08318C2.46119 2.0377 2.43247 2.01137 2.43007 2.00658C2.37502 1.95153 2.28884 1.94914 2.229 1.9994C2.16676 2.05207 2.16198 2.14542 2.21464 2.20766L2.39895 2.41591C2.50667 2.54996 2.64311 2.74385 2.75801 2.97604C3.04525 3.55771 3.05004 4.08672 2.77477 4.5511C2.43247 4.97718 2.1548 5.4248 1.94176 5.89636C1.13986 6.15727 0.852619 5.66896 0.84065 5.64741C0.84065 5.64502 0.838256 5.64502 0.838256 5.64263C0.687453 5.38889 0.747296 5.04659 0.977092 4.82877C1.15423 4.66121 1.46301 4.64684 1.55876 4.64684H1.56116C1.88191 4.64684 2.21224 4.59658 2.42528 4.22795C2.58806 3.94549 2.54497 3.59601 2.31517 3.36382C2.08298 3.12684 1.7335 3.08615 1.42232 3.25849C1.35051 3.29679 1.32418 3.38775 1.36487 3.45957C1.40317 3.53138 1.49413 3.55771 1.56594 3.51701C1.76462 3.4093 1.96569 3.42845 2.10453 3.57207C2.21703 3.68697 2.27927 3.88804 2.16916 4.08193C2.0375 4.30933 1.85798 4.35481 1.57073 4.35481C1.56834 4.35481 1.56594 4.35481 1.56116 4.35481C1.4295 4.35481 1.12311 4.37396 0.878949 4.53195V2.37043C0.878949 2.28904 0.811926 2.22202 0.73054 2.22202C0.649154 2.22202 0.58213 2.28904 0.58213 2.37043V4.85988C0.419358 5.15192 0.409783 5.50858 0.577342 5.79582C0.594098 5.82694 0.697028 5.99929 0.926824 6.12855C1.05848 6.20275 1.24758 6.27217 1.49892 6.27217C1.58988 6.27217 1.69042 6.2626 1.79813 6.24105C1.53961 6.93523 1.41035 7.68207 1.40557 8.49593C1.40557 8.49832 1.40557 8.49832 1.40557 8.50071V8.50311C1.40557 8.51029 1.40557 8.51747 1.40557 8.52226C1.40557 9.99199 1.92261 11.4354 2.86094 12.5868C3.69156 13.6065 4.82139 14.3629 6.07329 14.7483C5.94164 14.7291 5.80759 14.7196 5.67355 14.7196C4.79505 14.7196 3.99795 15.1385 3.49527 15.8063C3.45458 15.7536 3.4091 15.7034 3.35883 15.6603C3.51682 15.5645 3.62453 15.3922 3.62453 15.1935C3.62453 14.8943 3.38037 14.6501 3.08116 14.6501C3.0261 14.6501 2.97344 14.6597 2.92318 14.6741C2.91599 14.5807 2.89445 14.4922 2.86094 14.4132C2.63114 13.8985 2.21224 13.8124 1.83643 13.7717C1.71196 13.7573 1.29306 13.6951 1.07284 13.4365C0.79517 13.123 0.790382 12.6562 1.05608 12.3546C1.11114 12.2923 1.10396 12.199 1.04412 12.1463C0.981879 12.0913 0.888524 12.0985 0.835863 12.1583C0.474413 12.57 0.476807 13.2043 0.84065 13.6352C0.888524 13.6927 0.94358 13.7405 1.00103 13.7836C0.850225 13.8243 0.687453 13.8985 0.539043 14.0206C0.187168 14.3102 0.00763996 14.7938 0.00285254 15.452C-0.00911599 15.5119 0.0172148 15.5741 0.0698763 15.6076C0.0938134 15.622 0.120144 15.6292 0.146475 15.6292C0.15605 15.6292 0.168018 15.6268 0.177593 15.6244H0.179987C0.184774 15.6244 0.187168 15.622 0.191955 15.6196C0.199137 15.6172 0.208711 15.6148 0.215892 15.61C0.218286 15.61 0.218286 15.6076 0.22068 15.6076C0.244617 15.5933 0.26616 15.5741 0.280523 15.5502C0.337972 15.476 0.574949 15.3826 0.771233 15.3419C1.53961 15.1744 1.69999 14.6549 1.67605 14.406C1.66887 14.3246 1.59706 14.2648 1.51568 14.2719C1.43429 14.2791 1.37445 14.3509 1.38163 14.4323C1.38163 14.4347 1.38402 14.4778 1.36966 14.5424C1.33375 14.6908 1.2021 14.947 0.708996 15.0547C0.706602 15.0547 0.706603 15.0547 0.704209 15.0547C0.64676 15.0667 0.474413 15.1073 0.314034 15.1816C0.357121 14.7555 0.493563 14.4443 0.725752 14.2504C1.08241 13.9536 1.55397 14.0374 1.55876 14.0398C1.57552 14.0421 1.58988 14.0421 1.60424 14.0398C1.68324 14.0565 1.75026 14.0661 1.80053 14.0709C2.19549 14.114 2.43725 14.2001 2.58806 14.5376C2.70535 14.8033 2.55454 15.1097 2.35108 15.2629C2.24815 15.3419 1.97287 15.4975 1.66409 15.2438C1.60185 15.1911 1.50849 15.2007 1.45583 15.2629C1.40317 15.3252 1.41275 15.4185 1.47498 15.4712C1.61382 15.5861 1.76941 15.6531 1.92979 15.6723C1.72393 15.8398 1.58509 16.0505 1.52286 16.1606C1.32179 16.5077 1.15901 16.6944 0.888524 16.6968V15.6603C0.888524 15.5789 0.821501 15.5119 0.740115 15.5119C0.658728 15.5119 0.591705 15.5789 0.591705 15.6603V16.8619C0.591705 16.9218 0.62761 16.972 0.677878 16.996C0.704209 17.0151 0.735327 17.0295 0.768839 17.0295H4.21578C4.26844 17.0295 4.31153 17.0032 4.34025 16.9625C4.3594 16.9433 4.37616 16.9194 4.38334 16.8907C4.51978 16.3617 4.99613 15.993 5.54189 15.993C6.03021 15.993 6.46347 16.2898 6.64778 16.7327H6.33182C6.20256 16.4143 5.89137 16.2013 5.5395 16.2013C5.15411 16.2013 4.8142 16.4622 4.71128 16.8332C4.68973 16.9122 4.73761 16.9936 4.8142 17.0151C4.8932 17.0367 4.97458 16.9888 4.99613 16.9122C5.06315 16.668 5.28576 16.4981 5.5371 16.4981C5.72381 16.4981 5.89137 16.589 5.9943 16.7327H5.90813C5.82674 16.7327 5.75972 16.7997 5.75972 16.8811C5.75972 16.9625 5.82674 17.0295 5.90813 17.0295H6.20734C6.21213 17.0295 6.21931 17.0319 6.2241 17.0319C6.23128 17.0319 6.23846 17.0319 6.24325 17.0295H6.83689C6.91827 17.0295 6.9853 16.9625 6.9853 16.8811C6.9853 16.8739 6.9853 16.8667 6.9829 16.8595C6.9853 16.8404 6.9853 16.8188 6.98051 16.7973C6.80577 16.1486 6.21213 15.6962 5.5395 15.6962C4.88841 15.6962 4.31631 16.1175 4.11764 16.7327H3.34447C3.4067 16.534 3.49048 16.3497 3.59581 16.1773C3.60299 16.1678 3.60778 16.1582 3.61496 16.1486C4.05301 15.4616 4.81899 15.0212 5.66876 15.0212C6.17144 15.0212 6.65497 15.1744 7.06429 15.4616C7.07626 15.4688 7.08823 15.476 7.1002 15.4784C7.16243 15.5526 7.22467 15.6316 7.28451 15.713C7.29887 15.7321 7.31084 15.7513 7.3252 15.7704C7.31084 16.0744 7.47601 16.3928 7.81831 16.7183C7.83028 16.7542 7.84224 16.7853 7.84942 16.8093V16.8404C7.84942 16.9218 7.91645 16.9888 7.99784 16.9888C8.06725 16.9888 8.12231 16.9433 8.13906 16.8787C8.13906 16.8763 8.16061 16.8045 8.20369 16.6848C8.51248 16.3832 8.66568 16.0888 8.66329 15.8039C8.68244 15.7752 8.70398 15.7441 8.72552 15.7153C8.79255 15.6244 8.86196 15.5358 8.93377 15.452C9.34071 15.1696 9.81705 15.0212 10.3149 15.0212C11.3873 15.0212 12.3257 15.7201 12.6368 16.7327H11.8637C11.6674 16.1175 11.0953 15.6962 10.4418 15.6962C9.76918 15.6962 9.17793 16.1486 9.0008 16.7973C8.99362 16.8212 8.99362 16.8452 9.0008 16.8691C9.0008 16.8739 9.0008 16.8763 9.0008 16.8811C9.0008 16.9625 9.06782 17.0295 9.14921 17.0295H10.4466C10.528 17.0295 10.595 16.9625 10.595 16.8811C10.595 16.7997 10.528 16.7327 10.4466 16.7327H9.97504C10.078 16.589 10.2455 16.4981 10.4322 16.4981C10.6884 16.4981 10.911 16.6704 10.9756 16.9194C10.9924 16.9864 11.0522 17.0295 11.1192 17.0295C11.1312 17.0295 11.1432 17.0271 11.1551 17.0247C11.2341 17.0056 11.282 16.9242 11.2629 16.8452C11.1647 16.467 10.8248 16.2013 10.4322 16.2013C10.0828 16.2013 9.77157 16.4143 9.63992 16.7327H9.34071C9.52263 16.2898 9.95828 15.993 10.4466 15.993C10.9924 15.993 11.4687 16.3617 11.6052 16.8907C11.6075 16.9026 11.6147 16.9146 11.6195 16.9266C11.6387 16.9864 11.6937 17.0295 11.7607 17.0295H15.2723C15.3537 17.0295 15.4207 16.9625 15.4207 16.8811C15.4207 16.8787 15.4207 16.8739 15.4207 16.8715C15.4207 16.8691 15.4207 16.8643 15.4207 16.8619V16.8332C15.4231 16.8188 15.4231 16.8045 15.4231 16.7901C15.4231 16.7877 15.4231 16.7853 15.4207 16.7829V15.6603C15.4207 15.5789 15.3537 15.5119 15.2723 15.5119C15.1909 15.5119 15.1239 15.5789 15.1239 15.6603V16.6657C14.875 16.6465 14.7194 16.4622 14.5279 16.1319C14.4656 16.0265 14.3364 15.8279 14.1449 15.6651C14.2765 15.6364 14.4034 15.5741 14.5207 15.476C14.5829 15.4233 14.5925 15.33 14.5398 15.2677C14.4872 15.2055 14.3938 15.1959 14.3316 15.2486C14.0252 15.5023 13.7499 15.3467 13.6446 15.2677C13.4411 15.1145 13.2903 14.8057 13.4076 14.5424C13.5584 14.2049 13.8002 14.1164 14.1951 14.0757C14.2454 14.0709 14.3124 14.0613 14.3914 14.0445C14.4058 14.0469 14.4225 14.0469 14.4393 14.0445C14.4441 14.0445 14.9109 13.9584 15.2699 14.2552C15.5045 14.4491 15.6433 14.7603 15.684 15.1887C15.5213 15.1121 15.3465 15.0714 15.2915 15.0595C15.2891 15.0595 15.2891 15.0595 15.2867 15.0595C14.796 14.9518 14.6619 14.698 14.626 14.5496C14.6116 14.4874 14.6116 14.4443 14.614 14.4395C14.6212 14.3581 14.5614 14.2863 14.48 14.2791C14.3986 14.2719 14.3268 14.3318 14.3196 14.4132C14.2957 14.6645 14.4561 15.1816 15.2268 15.3491C15.4255 15.3922 15.6768 15.4903 15.7223 15.5645C15.7223 15.5645 15.7223 15.5669 15.7247 15.5669C15.7319 15.5765 15.7391 15.5861 15.7463 15.5933C15.7487 15.5957 15.7511 15.5957 15.7534 15.5981C15.7606 15.6028 15.7678 15.61 15.775 15.6124C15.7774 15.6148 15.7822 15.6172 15.7846 15.6172C15.7917 15.622 15.7989 15.6244 15.8061 15.6268C15.8085 15.6268 15.8133 15.6292 15.8157 15.6292C15.8253 15.6316 15.8372 15.634 15.8492 15.634C15.8588 15.634 15.866 15.634 15.8755 15.6316C15.8779 15.6316 15.8803 15.6316 15.8827 15.6292C15.8899 15.6268 15.8971 15.6244 15.9066 15.622H15.909C15.9162 15.6196 15.921 15.6148 15.9282 15.6124L15.9306 15.61C15.9354 15.6076 15.9402 15.6028 15.9426 15.6005C15.9449 15.5981 15.9497 15.5957 15.9521 15.5909C15.9545 15.5885 15.9593 15.5837 15.9617 15.5813C15.9641 15.5765 15.9689 15.5741 15.9713 15.5693C15.9737 15.5645 15.9761 15.5622 15.9785 15.5574C15.9808 15.5526 15.9832 15.5502 15.9856 15.5454C15.988 15.5406 15.988 15.5358 15.9904 15.531C15.9928 15.5262 15.9928 15.5215 15.9952 15.5167C15.9952 15.5119 15.9976 15.5071 15.9976 15.5047C15.9976 15.4999 16 15.4951 16 15.4879V15.4856C15.9976 14.8081 15.8157 14.3174 15.459 14.023ZM3.03807 16.7303H1.47977C1.61142 16.5962 1.70478 16.4359 1.77659 16.3114C1.83883 16.2037 2.06862 15.8446 2.39417 15.7513C2.77716 15.6387 3.13622 15.7704 3.31335 16.0744C3.19606 16.2779 3.1027 16.4981 3.03807 16.7303ZM3.07877 15.4449C2.94233 15.4449 2.83221 15.3347 2.83221 15.1983C2.83221 15.0619 2.94233 14.9518 3.07877 14.9518C3.21521 14.9518 3.32532 15.0619 3.32532 15.1983C3.32532 15.3347 3.21281 15.4449 3.07877 15.4449ZM11.8589 13.427C10.461 13.2642 9.45082 13.865 8.8476 14.3964C8.58669 14.6262 8.38083 14.8632 8.22524 15.0643C8.19651 15.0451 8.17018 15.026 8.14625 15.014V14.5927C9.27847 13.4557 10.4035 13.1158 11.1503 13.032C11.6458 12.9769 12.0456 13.0224 12.285 13.0679C12.1485 13.1948 12.0073 13.3145 11.8589 13.427ZM13.6135 11.3397C13.4699 11.6149 13.3047 11.8782 13.1228 12.132C12.9337 12.0721 12.6967 12.0171 12.4118 11.9907C13.0462 11.1865 13.4483 10.2266 13.5776 9.21404C13.7834 9.1901 14.0683 9.10153 14.2861 8.96031C14.2287 9.79092 14.0036 10.5904 13.6135 11.3397ZM12.6057 8.66827L12.7781 8.66109C12.8355 8.91722 13.0294 9.12308 13.2831 9.19249C13.1491 10.217 12.723 11.1841 12.0432 11.974C11.7153 11.974 11.3347 12.0123 10.9038 12.1056C11.9092 11.287 12.565 10.0542 12.6057 8.66827ZM9.79312 12.4503C9.69737 12.4886 9.63034 12.5197 9.59683 12.5341C9.19948 12.6921 8.7734 12.795 8.32817 12.8285L12.2993 8.85738C12.1796 10.4564 11.1839 11.8112 9.79312 12.4503ZM14.3005 8.50789C14.2957 8.64194 13.9294 8.85977 13.6063 8.91243C13.5608 8.91961 13.5153 8.9244 13.4722 8.9244C13.4148 8.9244 13.3597 8.91243 13.3095 8.89089C13.1587 8.82626 13.0533 8.67785 13.0533 8.5055C13.0533 8.33315 13.1587 8.18474 13.3095 8.12011C13.3597 8.09857 13.4148 8.0866 13.4722 8.0866C13.5153 8.0866 13.5608 8.09139 13.6063 8.09857C13.9294 8.15123 14.2933 8.36906 14.3005 8.50071C14.3005 8.50311 14.3005 8.5055 14.3005 8.50789ZM12.9145 4.72105L12.9767 4.80483C13.5201 5.53012 14.1568 6.65277 14.2789 8.0507C14.0635 7.91186 13.781 7.82329 13.5776 7.79936C13.4244 6.58814 12.8858 5.49422 12.0887 4.64924C12.1222 4.57982 12.1413 4.50083 12.1413 4.41944C12.1413 4.30933 12.1078 4.2064 12.0528 4.12262L12.7326 3.34706C12.6033 3.84016 12.6656 4.30694 12.9145 4.72105ZM10.9301 3.04306L10.9612 3.0646L10.978 3.07418C11.215 3.19386 11.4687 3.25371 11.732 3.25371C12.0097 3.25371 12.2993 3.18668 12.5914 3.05263L11.8254 3.92634C11.756 3.89283 11.6794 3.87607 11.5956 3.87607C11.4879 3.87607 11.3897 3.90719 11.3059 3.95985C10.5519 3.4093 9.65907 3.04306 8.68722 2.92337C8.66329 2.74863 8.61541 2.49969 8.5436 2.25553C9.31198 2.3417 10.1139 2.60501 10.9301 3.04306ZM11.8445 4.41944C11.8445 4.52716 11.7727 4.62051 11.6746 4.65403C11.6506 4.66121 11.6243 4.66599 11.598 4.66599C11.5908 4.66599 11.5812 4.66599 11.574 4.66599C11.4639 4.65642 11.3754 4.57264 11.3562 4.46732C11.3538 4.45295 11.3514 4.4362 11.3514 4.42184C11.3514 4.40508 11.3538 4.39072 11.3562 4.37396C11.3778 4.26624 11.4687 4.18246 11.5812 4.17528C11.586 4.17528 11.5932 4.17528 11.598 4.17528C11.6028 4.17528 11.6075 4.17528 11.6123 4.17528C11.7224 4.18246 11.8158 4.26146 11.8397 4.36678C11.8421 4.38114 11.8445 4.39311 11.8445 4.40747C11.8421 4.40987 11.8445 4.41465 11.8445 4.41944ZM8.69919 3.22498C9.58965 3.34227 10.4131 3.68218 11.1097 4.18486C11.0737 4.25667 11.0546 4.33566 11.0546 4.42184C11.0546 4.52955 11.0857 4.62769 11.1408 4.71387L9.94871 6.07349C9.89365 6.13573 9.90083 6.22909 9.96307 6.28175C9.99179 6.30568 10.0253 6.31765 10.0612 6.31765C10.1019 6.31765 10.1426 6.3009 10.1737 6.26738L11.3634 4.91015C11.4352 4.94606 11.5142 4.96521 11.6004 4.96521C11.7105 4.96521 11.811 4.9317 11.8948 4.87664C12.6368 5.67135 13.1371 6.69107 13.2855 7.8209C13.0294 7.89271 12.8307 8.10336 12.7781 8.36667L12.6081 8.37385C12.5722 7.27992 12.1485 6.23627 11.4089 5.4248C11.3538 5.36496 11.2605 5.36017 11.2006 5.41522C11.1408 5.47028 11.136 5.56363 11.191 5.62348C11.8421 6.3368 12.2299 7.24162 12.3041 8.19911L10.7123 6.61208C10.6549 6.55463 10.5615 6.55463 10.504 6.61208C10.4466 6.66953 10.4466 6.76288 10.504 6.82033L12.2132 8.52944L8.00023 12.7424L3.7873 8.52944L5.48205 6.83469C5.5395 6.77724 5.5395 6.68389 5.48205 6.62644C5.4246 6.56899 5.33125 6.56899 5.2738 6.62644L3.70113 8.19911C3.78491 7.10997 4.27323 6.13094 5.01767 5.41762L5.75972 6.26499C5.78844 6.2985 5.82914 6.31526 5.87222 6.31526C5.90573 6.31526 5.94164 6.30329 5.97037 6.27935C6.0326 6.2243 6.03739 6.13094 5.98473 6.0711L5.24028 5.22133C5.91052 4.66121 6.75071 4.29976 7.67229 4.23034L6.40841 5.48225C6.35097 5.5397 6.35097 5.63305 6.40841 5.6905C6.43714 5.71922 6.47544 5.73359 6.51374 5.73359C6.55204 5.73359 6.58794 5.71922 6.61906 5.6905L8.00741 4.31651L9.35507 5.66417C9.41252 5.72162 9.50587 5.72162 9.56332 5.66417C9.62077 5.60672 9.62077 5.51337 9.56332 5.45592L8.33774 4.23034C9.09655 4.28779 9.81945 4.54152 10.449 4.97478C10.516 5.02026 10.6094 5.00351 10.6549 4.93648C10.7003 4.86946 10.6836 4.7761 10.6166 4.73062C9.88886 4.23034 9.04149 3.95267 8.15582 3.92634V3.82101C8.43349 3.75399 8.65611 3.51701 8.69919 3.22498ZM4.37376 5.00351C4.45754 5.00351 4.53653 4.98436 4.60595 4.95085L4.81899 5.195C3.97401 6.00168 3.43543 7.12433 3.39234 8.37145L3.27266 8.36427C3.21521 8.08421 2.99738 7.86399 2.71732 7.80654C2.86333 6.69825 3.35165 5.69768 4.06976 4.91255C4.15833 4.96999 4.26126 5.00351 4.37376 5.00351ZM4.12721 4.46253C4.12721 4.45056 4.12721 4.44099 4.1296 4.42902C4.1296 4.42184 4.132 4.41705 4.132 4.40987C4.15354 4.30454 4.2445 4.22316 4.35461 4.21598C4.3594 4.21598 4.36419 4.21598 4.36658 4.21598C4.36897 4.21598 4.36898 4.21598 4.37137 4.21598C4.48387 4.21598 4.57962 4.29258 4.60835 4.3979C4.61313 4.41944 4.61792 4.44099 4.61792 4.46253C4.61792 4.47929 4.61553 4.49604 4.61313 4.5128C4.59159 4.61812 4.50063 4.69951 4.39052 4.70669C4.38334 4.70669 4.37855 4.70669 4.37137 4.70669C4.34025 4.70669 4.30913 4.69951 4.2828 4.68993C4.19423 4.65642 4.12721 4.56546 4.12721 4.46253ZM3.27026 8.66109L3.39234 8.66827C3.43304 10.0566 4.0913 11.2918 5.09906 12.1104C4.66579 12.0147 4.28519 11.9764 3.95486 11.974C3.27984 11.1865 2.85136 10.2242 2.71732 9.20446C2.99259 9.14701 3.21042 8.93397 3.27026 8.66109ZM3.69874 8.85738L7.6699 12.8285C5.55386 12.6682 3.85912 10.9734 3.69874 8.85738ZM7.5933 2.89704C7.65793 2.44942 7.87815 1.85099 7.99305 1.80312C8.1247 1.85339 8.32817 2.47336 8.3904 2.89465C8.40237 2.97843 8.40955 3.05503 8.40955 3.11727C8.40955 3.1436 8.40716 3.16753 8.40237 3.19147C8.36647 3.38536 8.19651 3.53377 7.99065 3.53377C7.7848 3.53377 7.61484 3.38536 7.57894 3.19147C7.57415 3.16753 7.57175 3.1412 7.57175 3.11727C7.57415 3.05263 7.58133 2.97843 7.5933 2.89704ZM7.85182 3.81862V3.92155C6.78423 3.95506 5.80759 4.35481 5.04161 4.99633L4.83096 4.75456C4.88602 4.67078 4.91953 4.56785 4.91953 4.46013C4.91953 4.36917 4.89559 4.283 4.85729 4.2088C5.55865 3.69415 6.38926 3.34706 7.29169 3.22498C7.33238 3.5218 7.55979 3.76117 7.85182 3.81862ZM4.19663 3.25371C4.45994 3.25371 4.71367 3.19386 4.95304 3.07418C4.9674 3.067 6.33421 2.35607 7.4401 2.26032C7.36829 2.50208 7.32042 2.75342 7.29648 2.92577C6.31266 3.04785 5.40545 3.42845 4.64665 3.99336C4.56526 3.94549 4.4743 3.91916 4.37376 3.91916C4.28998 3.91916 4.21099 3.93831 4.14157 3.97182L3.33729 3.05503C3.63171 3.18668 3.91896 3.25371 4.19663 3.25371ZM3.00217 4.73541L3.01414 4.71866C3.26308 4.30694 3.32532 3.83777 3.20085 3.34467L3.91896 4.16571C3.8639 4.24949 3.83039 4.35242 3.83039 4.46013C3.83039 4.53913 3.84715 4.61333 3.87826 4.68275C3.09552 5.52533 2.56891 6.60729 2.4181 7.80414C2.20506 7.83766 1.92261 7.92862 1.70957 8.06506C1.79335 6.80118 2.21703 5.70726 3.00217 4.73541ZM1.6976 8.50311C1.70238 8.36427 2.08777 8.17278 2.39177 8.11054C2.4588 8.09618 2.52103 8.089 2.57369 8.089C2.61439 8.089 2.65029 8.09378 2.68859 8.10575C2.86333 8.15602 2.99259 8.3164 2.99259 8.50789C2.99259 8.69939 2.86333 8.85977 2.68859 8.91004C2.65269 8.91961 2.61439 8.92679 2.57369 8.92679C2.51864 8.92679 2.4564 8.91961 2.39177 8.90525C2.08777 8.84062 1.70238 8.64912 1.6976 8.51029C1.6976 8.5055 1.6976 8.5055 1.6976 8.50311ZM1.71196 8.94355C1.925 9.08238 2.20985 9.17335 2.4205 9.20686C2.54736 10.2218 2.94951 11.1841 3.58623 11.9883C3.30138 12.0147 3.0644 12.0673 2.87291 12.1272C2.18591 11.1841 1.78856 10.0949 1.71196 8.94355ZM3.08595 12.4049C3.07877 12.3953 3.07159 12.3881 3.0644 12.3785C3.78491 12.1798 4.57244 12.2852 5.12539 12.4168C5.79323 12.5772 6.28155 12.8094 6.28633 12.8118L6.28873 12.807C6.81774 13.0176 7.39462 13.1349 7.99784 13.1349C8.59866 13.1349 9.17315 13.02 9.69976 12.8094C9.69976 12.8094 9.70455 12.807 9.71412 12.8022C9.77636 12.7759 9.84099 12.7495 9.90083 12.7208C10.1043 12.637 10.4466 12.5126 10.8583 12.4144C11.416 12.2804 12.206 12.1751 12.9265 12.3761C12.802 12.5293 12.6727 12.6753 12.5339 12.8166C12.3328 12.7615 11.8206 12.6562 11.1288 12.7304C10.3772 12.8118 9.27129 13.1325 8.14146 14.1762V13.9153C8.14146 13.8339 8.07443 13.7669 7.99305 13.7669C7.91166 13.7669 7.84464 13.8339 7.84464 13.9153V14.1618C6.72199 13.1301 5.62088 12.8118 4.87405 12.7304C4.16551 12.6538 3.64607 12.7687 3.45697 12.8214C3.3325 12.6921 3.20563 12.5509 3.08595 12.4049ZM3.71549 13.0703C3.95486 13.0224 4.3594 12.9746 4.86447 13.032C6.19298 13.1804 7.2127 13.9392 7.85182 14.5759V15.0092C7.83028 15.0212 7.80634 15.0355 7.78001 15.0547C7.62442 14.856 7.42095 14.6238 7.16482 14.3988C6.56161 13.865 5.54668 13.2618 4.14397 13.4294V13.4318C3.99556 13.3169 3.85193 13.1972 3.71549 13.0703ZM7.43292 15.4161C7.15286 15.0571 6.84646 14.7866 6.54007 14.5831L6.54246 14.5759C6.53528 14.5735 6.5281 14.5712 6.52092 14.5712C6.01106 14.2384 5.4988 14.0924 5.08709 14.0326C4.8932 13.932 4.7017 13.8195 4.51738 13.6975C5.41981 13.6711 6.23846 13.9775 6.96136 14.6118C7.21031 14.8297 7.40659 15.0547 7.555 15.2486C7.50952 15.2988 7.46883 15.3539 7.43292 15.4161ZM8.14864 16.3138C8.11273 16.3569 8.07443 16.3999 8.03135 16.443C8.02177 16.4526 8.0098 16.4646 7.99784 16.4742L7.99544 16.4765L7.99305 16.4789V16.4742C7.98826 16.4694 7.98108 16.4646 7.97629 16.4574C7.92842 16.4119 7.88772 16.3664 7.84942 16.321C7.67468 16.1127 7.59809 15.9188 7.62442 15.7417C7.62681 15.7273 7.6292 15.713 7.63399 15.6986C7.65314 15.622 7.68905 15.555 7.73213 15.4975C7.76804 15.4496 7.80873 15.409 7.84942 15.373C7.88533 15.3419 7.92124 15.3156 7.95235 15.2941C7.96672 15.2845 7.97869 15.2773 7.99065 15.2701C7.99065 15.2701 7.99305 15.2701 7.99305 15.2677H7.99544C8.0122 15.2773 8.02895 15.2893 8.0505 15.3036C8.07922 15.3228 8.11273 15.3491 8.14625 15.3778C8.18933 15.4161 8.23242 15.4616 8.26832 15.5119C8.31141 15.5741 8.34732 15.6435 8.36168 15.7225C8.36168 15.7273 8.36407 15.7345 8.36647 15.7393C8.3928 15.914 8.31859 16.1055 8.14864 16.3138ZM8.7327 15.2342C8.72792 15.239 8.72313 15.2438 8.72073 15.2486C8.66568 15.3108 8.61541 15.373 8.56993 15.4329C8.53403 15.3707 8.49333 15.3132 8.45025 15.2629C8.59866 15.069 8.79973 14.8369 9.05346 14.6142C9.77157 13.9823 10.5878 13.6759 11.4831 13.6975C11.2964 13.8195 11.1049 13.9344 10.9086 14.035C9.88408 14.1906 9.18272 14.722 8.7327 15.2342ZM12.9097 14.9518C13.0462 14.9518 13.1563 15.0619 13.1563 15.1983C13.1563 15.3347 13.0462 15.4449 12.9097 15.4449C12.7733 15.4449 12.6632 15.3347 12.6632 15.1983C12.6632 15.0643 12.7733 14.9518 12.9097 14.9518ZM13.6566 15.7201C13.9821 15.8159 14.2119 16.1725 14.2741 16.2803C14.3507 16.4143 14.4537 16.5914 14.6045 16.7303H12.9504C12.8882 16.5053 12.7996 16.2922 12.6871 16.0959C12.869 15.7704 13.276 15.6076 13.6566 15.7201Z" fill="#0F172A"/><path d="M1.04297 5.3174C1.04297 5.55916 1.23925 5.75784 1.48341 5.75784C1.72757 5.75784 1.92385 5.56155 1.92385 5.3174C1.92385 5.07563 1.72757 4.87695 1.48341 4.87695C1.23925 4.87695 1.04297 5.07563 1.04297 5.3174ZM1.62703 5.3174C1.62703 5.39639 1.5624 5.46102 1.48341 5.46102C1.40442 5.46102 1.33979 5.39639 1.33979 5.3174C1.33979 5.2384 1.40442 5.17377 1.48341 5.17377C1.5624 5.17377 1.62703 5.2384 1.62703 5.3174Z" fill="#0F172A"/><path d="M14.9165 5.3174C14.9165 5.07563 14.7202 4.87695 14.4761 4.87695C14.2343 4.87695 14.0356 5.07324 14.0356 5.3174C14.0356 5.55916 14.2319 5.75784 14.4761 5.75784C14.7202 5.75784 14.9165 5.56155 14.9165 5.3174ZM14.3325 5.3174C14.3325 5.2384 14.3971 5.17377 14.4761 5.17377C14.5551 5.17377 14.6197 5.2384 14.6197 5.3174C14.6197 5.39639 14.5551 5.46102 14.4761 5.46102C14.3971 5.46341 14.3325 5.39878 14.3325 5.3174Z" fill="#0F172A"/><path d="M15.336 6.41086C15.281 6.38932 15.2163 6.40128 15.1732 6.44437C14.9793 6.64305 14.661 6.63587 14.6562 6.63587C14.6538 6.63587 14.6514 6.63587 14.6514 6.63587C14.5724 6.63587 14.5078 6.6981 14.503 6.7771C14.5006 6.85848 14.5628 6.9279 14.6442 6.93029C14.6586 6.93029 14.8932 6.93747 15.1325 6.82736V9.24262C15.1325 9.324 15.1996 9.39103 15.281 9.39103C15.3623 9.39103 15.4294 9.324 15.4294 9.24262V6.5473C15.427 6.48746 15.3911 6.4324 15.336 6.41086Z" fill="#0F172A"/><path d="M0.708578 9.39103C0.789964 9.39103 0.856988 9.324 0.856988 9.24262V6.82736C1.09636 6.93747 1.33094 6.93029 1.3453 6.93029C1.42669 6.9279 1.49132 6.85848 1.48653 6.7771C1.48414 6.69571 1.41472 6.63108 1.33334 6.63587C1.33094 6.63587 1.01019 6.64305 0.816295 6.44437C0.773208 6.40128 0.710972 6.38932 0.653523 6.41086C0.598468 6.4324 0.562562 6.48746 0.562562 6.5473V9.24501C0.560168 9.32639 0.627192 9.39103 0.708578 9.39103Z" fill="#0F172A"/><path d="M15.4501 11.8589C15.4501 11.7775 15.3831 11.7104 15.3017 11.7104H14.3442C14.2628 11.7104 14.1958 11.7775 14.1958 11.8589C14.1958 11.9402 14.2628 12.0073 14.3442 12.0073H15.3017C15.3831 12.0073 15.4501 11.9426 15.4501 11.8589Z" fill="#0F172A"/><path d="M14.4545 12.4218C14.5359 12.4218 14.603 12.3548 14.603 12.2734C14.603 12.192 14.5359 12.125 14.4545 12.125H14.0859C14.0045 12.125 13.9375 12.192 13.9375 12.2734C13.9375 12.3548 14.0045 12.4218 14.0859 12.4218H14.4545Z" fill="#0F172A"/><path d="M14.805 12.6977C14.805 12.6163 14.7379 12.5493 14.6566 12.5493H13.7422C13.6608 12.5493 13.5938 12.6163 13.5938 12.6977C13.5938 12.7791 13.6608 12.8461 13.7422 12.8461H14.6566C14.7379 12.8461 14.805 12.7815 14.805 12.6977Z" fill="#0F172A"/><path d="M14.2269 13.1216C14.2269 13.0402 14.1599 12.9731 14.0785 12.9731H13.3628C13.2814 12.9731 13.2144 13.0402 13.2144 13.1216C13.2144 13.2029 13.2814 13.27 13.3628 13.27H14.0785C14.1599 13.27 14.2269 13.2029 14.2269 13.1216Z" fill="#0F172A"/><path d="M12.9101 13.3882C12.8287 13.3882 12.7617 13.4552 12.7617 13.5366C12.7617 13.618 12.8287 13.685 12.9101 13.685H13.3171C13.3984 13.685 13.4655 13.618 13.4655 13.5366C13.4655 13.4552 13.3984 13.3882 13.3171 13.3882H12.9101Z" fill="#0F172A"/><path d="M15.2989 10.8716H14.7651C14.6837 10.8716 14.6167 10.9386 14.6167 11.02C14.6167 11.1014 14.6837 11.1684 14.7651 11.1684H15.2989C15.3803 11.1684 15.4473 11.1014 15.4473 11.02C15.4473 10.9386 15.3803 10.8716 15.2989 10.8716Z" fill="#0F172A"/><path d="M15.2957 11.2861H14.5512C14.4699 11.2861 14.4028 11.3532 14.4028 11.4345C14.4028 11.5159 14.4699 11.583 14.5512 11.583H15.2957C15.3771 11.583 15.4441 11.5159 15.4441 11.4345C15.4441 11.3532 15.3771 11.2861 15.2957 11.2861Z" fill="#0F172A"/><path d="M15.296 10.0142H15.0591C14.9777 10.0142 14.9106 10.0812 14.9106 10.1626C14.9106 10.244 14.9777 10.311 15.0591 10.311H15.296C15.3774 10.311 15.4444 10.244 15.4444 10.1626C15.4444 10.0812 15.3774 10.0142 15.296 10.0142Z" fill="#0F172A"/><path d="M15.2974 10.4385H14.9336C14.8522 10.4385 14.7852 10.5055 14.7852 10.5869C14.7852 10.6683 14.8522 10.7353 14.9336 10.7353H15.2974C15.3788 10.7353 15.4458 10.6683 15.4458 10.5869C15.4458 10.5055 15.3788 10.4385 15.2974 10.4385Z" fill="#0F172A"/><path d="M0.7099 9.87586C0.791307 9.87586 0.857301 9.80986 0.857301 9.72846C0.857301 9.64705 0.791307 9.58105 0.7099 9.58105C0.628493 9.58105 0.5625 9.64705 0.5625 9.72846C0.5625 9.80986 0.628493 9.87586 0.7099 9.87586Z" fill="#0F172A"/><path d="M1.30365 13.2679C1.38506 13.2679 1.45105 13.202 1.45105 13.1205C1.45105 13.0391 1.38506 12.9731 1.30365 12.9731C1.22224 12.9731 1.15625 13.0391 1.15625 13.1205C1.15625 13.202 1.22224 13.2679 1.30365 13.2679Z" fill="#0F172A"/><path d="M2.24408 13.6923C2.32549 13.6923 2.39148 13.6263 2.39148 13.5449C2.39148 13.4635 2.32549 13.3975 2.24408 13.3975C2.16267 13.3975 2.09668 13.4635 2.09668 13.5449C2.09668 13.6263 2.16267 13.6923 2.24408 13.6923Z" fill="#0F172A"/><path d="M0.687472 12.017H1.64496C1.72634 12.017 1.79337 11.95 1.79337 11.8686C1.79337 11.7872 1.72634 11.7202 1.64496 11.7202H0.687472C0.606086 11.7202 0.539062 11.7872 0.539062 11.8686C0.539062 11.9524 0.606086 12.017 0.687472 12.017Z" fill="#0F172A"/><path d="M1.90767 12.1445H1.53903C1.45765 12.1445 1.39062 12.2116 1.39062 12.2929C1.39062 12.3743 1.45765 12.4414 1.53903 12.4414H1.90767C1.98905 12.4414 2.05608 12.3743 2.05608 12.2929C2.05608 12.2116 1.98905 12.1445 1.90767 12.1445Z" fill="#0F172A"/><path d="M2.2381 12.5586H1.3237C1.24232 12.5586 1.17529 12.6256 1.17529 12.707C1.17529 12.7884 1.24232 12.8554 1.3237 12.8554H2.2381C2.31949 12.8554 2.38651 12.7884 2.38651 12.707C2.38651 12.6232 2.31949 12.5586 2.2381 12.5586Z" fill="#0F172A"/><path d="M2.62194 12.9731H1.90622C1.82484 12.9731 1.75781 13.0402 1.75781 13.1216C1.75781 13.2029 1.82484 13.27 1.90622 13.27H2.62194C2.70333 13.27 2.77035 13.2029 2.77035 13.1216C2.77035 13.0402 2.70333 12.9731 2.62194 12.9731Z" fill="#0F172A"/><path d="M2.53906 13.5459C2.53906 13.6273 2.60609 13.6943 2.68747 13.6943H3.0944C3.17579 13.6943 3.24281 13.6273 3.24281 13.5459C3.24281 13.4645 3.17579 13.3975 3.0944 13.3975H2.68747C2.60609 13.3975 2.53906 13.4645 2.53906 13.5459Z" fill="#0F172A"/><path d="M0.687472 11.1684H1.22127C1.30266 11.1684 1.36968 11.1014 1.36968 11.02C1.36968 10.9386 1.30266 10.8716 1.22127 10.8716H0.687472C0.606086 10.8716 0.539062 10.9386 0.539062 11.02C0.539063 11.1014 0.606086 11.1684 0.687472 11.1684Z" fill="#0F172A"/><path d="M0.687472 11.5922H1.43192C1.5133 11.5922 1.58033 11.5252 1.58033 11.4438C1.58033 11.3624 1.5133 11.2954 1.43192 11.2954H0.687472C0.606086 11.2954 0.539062 11.3624 0.539062 11.4438C0.539063 11.5252 0.606086 11.5922 0.687472 11.5922Z" fill="#0F172A"/><path d="M0.687472 10.3203H0.924449C1.00584 10.3203 1.07286 10.2532 1.07286 10.1718C1.07286 10.0905 1.00584 10.0234 0.924449 10.0234H0.687472C0.606086 10.0234 0.539062 10.0905 0.539062 10.1718C0.539063 10.2532 0.606086 10.3203 0.687472 10.3203Z" fill="#0F172A"/><path d="M0.687472 10.7446H1.05132C1.1327 10.7446 1.19973 10.6776 1.19973 10.5962C1.19973 10.5148 1.1327 10.4478 1.05132 10.4478H0.687472C0.606086 10.4478 0.539062 10.5148 0.539062 10.5962C0.539063 10.6799 0.606086 10.7446 0.687472 10.7446Z" fill="#0F172A"/><path d="M7.99268 16.4788C7.99646 16.475 7.99268 16.475 7.99268 16.4712V16.4788Z" fill="#0F172A"/><path d="M14.7267 2.96587C14.7291 2.96587 14.7291 2.96587 14.7267 2.96587C14.7937 2.96587 14.8535 2.92039 14.8703 2.85336C14.923 2.64272 14.9014 2.46319 14.8009 2.31478C14.6405 2.07541 14.3461 2.02993 14.3126 2.02514C14.236 2.01556 14.1642 2.06344 14.1474 2.14004C14.0923 2.39138 14.1235 2.59245 14.2431 2.74086C14.4203 2.95629 14.698 2.96347 14.7267 2.96587ZM14.5591 2.48234C14.5878 2.52782 14.6046 2.58048 14.6046 2.64272C14.5615 2.62596 14.5136 2.59963 14.4801 2.55654C14.4418 2.50867 14.4227 2.44643 14.4227 2.36744C14.4705 2.39138 14.5232 2.42968 14.5591 2.48234Z" fill="#0F172A"/><path d="M13.7657 0.820638C13.6053 0.581267 13.3109 0.535787 13.2774 0.530999C13.2008 0.521424 13.129 0.569299 13.1122 0.645897C13.0572 0.897236 13.0883 1.09831 13.208 1.24672C13.3803 1.46215 13.658 1.46933 13.6891 1.46933C13.7561 1.46933 13.816 1.42385 13.8327 1.35683C13.8878 1.15097 13.8663 0.969048 13.7657 0.820638ZM13.4426 1.0624C13.4043 1.01453 13.3851 0.952292 13.3851 0.873299C13.4354 0.897236 13.4881 0.935536 13.5216 0.988197C13.5503 1.03368 13.567 1.08634 13.567 1.14858C13.524 1.13182 13.4761 1.10549 13.4426 1.0624Z" fill="#0F172A"/><path d="M1.69827 2.02509C1.66475 2.02988 1.37272 2.07536 1.20995 2.31473C1.11181 2.46314 1.08787 2.64267 1.14053 2.85331C1.15729 2.91794 1.21713 2.96582 1.28416 2.96582C1.31527 2.96582 1.59294 2.95864 1.76529 2.7432C1.88498 2.59479 1.91609 2.39133 1.86104 2.14238C1.84668 2.06579 1.77487 2.01552 1.69827 2.02509ZM1.53789 2.5565C1.50438 2.59958 1.4565 2.62591 1.41102 2.64267C1.41102 2.58043 1.42778 2.52538 1.4565 2.48229C1.49241 2.42963 1.54507 2.39133 1.59294 2.36739C1.59294 2.44638 1.57379 2.50862 1.53789 2.5565Z" fill="#0F172A"/><path d="M2.73342 0.530952C2.69991 0.535739 2.40788 0.58122 2.24511 0.820591C2.14696 0.969001 2.12303 1.14853 2.17569 1.35917C2.19245 1.42381 2.25229 1.47168 2.31931 1.47168C2.35043 1.47168 2.6281 1.4645 2.80045 1.24906C2.92013 1.10065 2.95125 0.897189 2.89619 0.648244C2.87944 0.571645 2.81002 0.521377 2.73342 0.530952ZM2.57065 1.06236C2.53714 1.10544 2.48926 1.13177 2.44378 1.14853C2.44378 1.08629 2.46054 1.03124 2.48926 0.98815C2.52517 0.935489 2.57783 0.897189 2.62571 0.873252C2.62571 0.952245 2.60895 1.01448 2.57065 1.06236Z" fill="#0F172A"/><path d="M12.6672 7.49792C12.6768 7.57451 12.739 7.62957 12.8132 7.62957C12.818 7.62957 12.8252 7.62957 12.83 7.62957C12.9114 7.61999 12.9688 7.54579 12.9593 7.4644C12.8109 6.1718 11.9276 5.25741 11.8893 5.21911C11.8318 5.16166 11.7385 5.15926 11.681 5.21671C11.6236 5.27416 11.6212 5.36752 11.6786 5.42497C11.6882 5.43454 12.5308 6.30824 12.6672 7.49792Z" fill="#0F172A"/><path d="M3.19036 7.60999C3.19515 7.60999 3.20233 7.60999 3.20712 7.60999C3.28133 7.60999 3.34596 7.55494 3.35314 7.47834C3.48958 6.28867 4.33216 5.41496 4.33934 5.40778C4.39679 5.35033 4.3944 5.25459 4.33695 5.19953C4.2795 5.14208 4.18375 5.14208 4.1287 5.20192C4.0904 5.24022 3.20951 6.15462 3.05871 7.44722C3.05153 7.52861 3.10898 7.60042 3.19036 7.60999Z" fill="#0F172A"/></svg>
														<div class="cx-vui-tooltip" v-if="module.isBlocks">
															<?php _e( 'Supports Blocks views', 'jet-engine' ); ?>
														</div>
														<div class="cx-vui-tooltip" v-else>
															<?php _e( 'Don`t supports Blocks views', 'jet-engine' ); ?>
														</div>
													</div>
												</div>
											</div>
											<div class="cx-vui-repeater-item__heading-end">
												<div class="jet-engine-module-info" @click="moduleDetails = module.value" v-if="moduleDetails !== module.value">
													<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><rect x="0" fill="none" width="20" height="20"/><g><path d="M10 2c4.42 0 8 3.58 8 8s-3.58 8-8 8-8-3.58-8-8 3.58-8 8-8zm1 4c0-.55-.45-1-1-1s-1 .45-1 1 .45 1 1 1 1-.45 1-1zm0 9V9H9v6h2z"/></g></svg>
													<div class="cx-vui-tooltip">
														<?php _e( 'Click here to get more info', 'jet-engine' ); ?>
													</div>
												</div>
												<div class="jet-enine-module-info-close" @click="moduleDetails = null" v-else>
													<svg width="20" height="20" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 3.00671L8.00671 7L12 10.9933L10.9933 12L7 8.00671L3.00671 12L2 10.9933L5.99329 7L2 3.00671L3.00671 2L7 5.99329L10.9933 2L12 3.00671Z"></path></svg>
												</div>
											</div>
										</div>
										<div :class="{ 'cx-vui-repeater-item__content': true, 'cx-vui-repeater-item__content--is-collpased': moduleDetails !== module.value }">
											<div class="jet-engine-module">
												<keep-alive>
													<jet-video-embed v-if="module.embed && moduleDetails === module.value" :embed="module.embed">
												</keep-alive>
												<div class="jet-engine-module-content">
													<div class="jet-engine-details" v-if="module.details" v-html="module.details"></div>
														<div class="jet-engine-links" v-if="module.links.length">
															<div class="jet-engine-links__title">
																<?php _e( 'Useful links:', 'jet-engine' ); ?>
															</div>
															<div class="jet-engine-links__item" v-for="link in module.links">
																<a :href="link.url" target="_blank" class="jet-engine-links__link">
																	<svg v-if="link.is_video" width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><rect x="0" fill="none" width="20" height="20"/><g><path d="M19 15V5c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h13c1.1 0 2-.9 2-2zM8 14V6l6 4z"/></g></svg>
																	<svg v-else width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><rect x="0" fill="none" width="20" height="20"/><g><path d="M10 10L2.54 7.02 3 18H1l.48-11.41L0 6l10-4 10 4zm0-5c-.55 0-1 .22-1 .5s.45.5 1 .5 1-.22 1-.5-.45-.5-1-.5zm0 6l5.57-2.23c.71.94 1.2 2.07 1.36 3.3-.3-.04-.61-.07-.93-.07-2.55 0-4.78 1.37-6 3.41C8.78 13.37 6.55 12 4 12c-.32 0-.63.03-.93.07.16-1.23.65-2.36 1.36-3.3z"/></g></svg>
																	{{ link.label }}
																</a>
															</div>
														</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</cx-vui-component-wrapper>

					<cx-vui-component-wrapper
						:wrapper-css="[ 'vertical-fullwidth', 'jet-is-stackable' ]"
					>
						<cx-vui-button
							button-style="accent"
							:loading="saving"
							@click="saveModules"
						>
							<span
								slot="label"
								v-html="'<?php _e( 'Save', 'jet-engine' ); ?>'"
							></span>
						</cx-vui-button>
						&nbsp;&nbsp;&nbsp;&nbsp;
						<span
							class="cx-vui-inline-notice cx-vui-inline-notice--success"
							v-if="'success' === result"
							v-html="successMessage"
						></span>
						<span
							class="cx-vui-inline-notice cx-vui-inline-notice--error"
							v-if="'error' === result"
							v-html="errorMessage"
						></span>
					</cx-vui-component-wrapper>
				</cx-vui-tabs-panel>
				<cx-vui-tabs-panel
					name="skins"
					label="<?php _e( 'Skins Manager', 'jet-engine' ); ?>"
					key="skins"
				>
					<br>
					<div
						class="cx-vui-subtitle"
						v-html="'<?php _e( 'Skins manager', 'jet-engine' ); ?>'"
					></div>
					<div class="jet-engine-skins-wrap">
						<jet-engine-skin-import></jet-engine-skin-import>
						<jet-engine-skin-export></jet-engine-skin-export>
						<jet-engine-skins-presets></jet-engine-skins-presets>
					</div>
				</cx-vui-tabs-panel>
				<cx-vui-tabs-panel
					name="shortcode_generator"
					label="<?php _e( 'Shortcode Generator', 'jet-engine' ); ?>"
					key="shortcode_generator"
				>
					<div
						class="cx-vui-subtitle"
						v-html="'<?php _e( 'Generate shortcode', 'jet-engine' ); ?>'"
					></div>
					<div class="jet-shortocde-generator">
						<p><?php
							_e( 'Generate shortcode to output JetEngine-related data anywhere in content', 'jet-engine' );
						?></p>
						<cx-vui-select
							label="<?php _e( 'Component', 'jet-engine' ); ?>"
							description="<?php _e( 'Select plugin component to get value from', 'jet-engine' ); ?>"
							:options-list="componentsList"
							:wrapper-css="[ 'equalwidth' ]"
							size="fullwidth"
							v-model="shortcode.component"
						></cx-vui-select>
						<cx-vui-input
							label="<?php _e( 'Meta Fields Name', 'jet-engine' ); ?>"
							description="<?php _e( 'Set meta field name to get value from', 'jet-engine' ); ?>"
							:wrapper-css="[ 'equalwidth' ]"
							size="fullwidth"
							v-model="shortcode.meta_field"
							:conditions="[
								{
									input: this.shortcode.component,
									compare: 'equal',
									value: 'meta_field',
								}
							]"
						></cx-vui-input>
						<cx-vui-input
							label="<?php _e( 'Page Slug', 'jet-engine' ); ?>"
							description="<?php _e( 'Set created option page slug to get option from', 'jet-engine' ); ?>"
							:wrapper-css="[ 'equalwidth' ]"
							size="fullwidth"
							v-model="shortcode.page"
							:conditions="[
								{
									input: this.shortcode.component,
									compare: 'equal',
									value: 'option',
								}
							]"
						></cx-vui-input>
						<cx-vui-input
							label="<?php _e( 'Field Name', 'jet-engine' ); ?>"
							description="<?php _e( 'Set option field name to get value from', 'jet-engine' ); ?>"
							:wrapper-css="[ 'equalwidth' ]"
							size="fullwidth"
							v-model="shortcode.field"
							:conditions="[
								{
									input: this.shortcode.component,
									compare: 'equal',
									value: 'option',
								}
							]"
						></cx-vui-input>
						<cx-vui-input
							label="<?php _e( 'Post ID', 'jet-engine' ); ?>"
							description="<?php _e( 'Be default shortcodetries automatically detect post ID, use this option to set specific post ID', 'jet-engine' ); ?>"
							:wrapper-css="[ 'equalwidth' ]"
							size="fullwidth"
							v-model="shortcode.post_id"
							:conditions="[
								{
									input: this.shortcode.component,
									compare: 'equal',
									value: 'meta_field',
								}
							]"
						></cx-vui-input>
						<?php do_action( 'jet-engine/dashboard/shortcode-generator/custom-controls' ); ?>
						<div class="jet-shortocde-generator__result">
							{{ generatedShortcode }}
							<div
								class="jet-shortocde-generator__result-copy"
								role="button"
								v-if="showCopyShortcode"
								@click="copyShortcodeToClipboard"
							>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24px" height="24px"><path d="M0 0h24v24H0z" fill="none"/><path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg>
								<div
									class="cx-vui-tooltip"
									v-if="shortcode.copied"
								>
									<?php _e( 'Copied!', 'jet-engine' ); ?>
								</div>
							</div>
						</div>
					</div>
				</cx-vui-tabs-panel>
				<?php do_action( 'jet-engine/dashboard/tabs' ); ?>
			</cx-vui-tabs>
		</div>
	</div>
</div>
